<?php
define('_VALID', true);
require 'include/config.php';
require 'include/function_global.php';
require 'classes/filter.class.php';
require 'classes/validation.class.php';
require 'include/function_smarty.php';
require 'classes/email.class.php';

if ( $config['user_registration'] == '0' ) {
    VRedirect::go($config['BASE_DIR']. '/error/registration_disabled');
}

$signup     = array('username' => '', 'email' => '', 'age' => '', 'terms' => '', 'gender' => '');
if ( isset($_POST['submit_signup']) ) {
    $filter             = new VFilter();
    $valid              = new VValidation();
    $username           = $filter->get('username');
    $password           = $filter->get('password');
    $password_confirm   = $filter->get('password_confirm');
    $email              = $filter->get('email');
    $vcode              = $filter->get('verification');
    $age                = $filter->get('age');
    $terms              = $filter->get('terms');
    $gender             = $filter->get('gender');
    
    if ( $username == '' ) {
        $errors[]               = 'Username field cannot be blank!';
    } elseif ( strlen($username) > 15 ) {
        $errors[]               = 'Username can contain only 15 characters!';
    } elseif ( !$valid->username($username) ) {
        $errors[]               = 'Username is invalid. Username can only contain alphanumeric characters and _!';
    } elseif ( $valid->usernameExists($username) ) {
        $errors[]               = 'Username already exists!';
    } else {
        $signup['username']     = $username;
    }
    
    if ( $email == '' ) {
        $errors[]               = 'Email field cannot be blank!';
    } elseif ( !$valid->email($email) ) {
        $errors[]               = 'Email is not a valid email address!';
    } elseif ( $valid->emailExists($email) ) {
        $errors[]               = 'Email is already used by another user!';
    } else {
        $signup['email']        = $email;
    }
    
    if ( $password == '' ) {
        $errors[]               = 'Password field cannot be blank!';
    } elseif ( $password_confirm == '' ) {
        $errors[]               = 'Password confirm field cannot be blank!';
    } elseif ( $password != $password_confirm ) {
        $errors[]               = 'Password and confirmation password are not the same!';
    }
    
    if ( $config['captcha'] == '1' ) {
        if ( $_SESSION['captcha_code'] != strtoupper($vcode) ) {
            $errors[]               = 'Invalid verification code! Are you human?';
        }
    }
    
    if ( $age == '' ) {
        $errors[]               = 'Sorry, you need to be at least 18 years old to create an account!';
    } else {
        $signup['age']          = 'on';
    }
    
    if ( $terms == '' ) {
        $errors[]               = 'Sorry, you need to agree to the Terms of Use and Privacy Policy to create an account!';
    } else {
        $signup['terms']        = 'on';
    }
    
    if ( $gender == '' ) {
        $errors[]               = 'Please select your gender!';
    } else {
        $gender                 = ( $gender == 'Male' ) ? 'Male' : 'Female';
        $signup['gender']       = $gender;
    }
    
    if ( !$errors ) {
        require 'classes/random.class.php';
		$password_clear = $password;
        $password       = md5($password);
        $sql            = "INSERT INTO signup SET email = '" .mysql_real_escape_string($email). "', username = '" .mysql_real_escape_string($username). "',
                                              pwd = '" .mysql_real_escape_string($password). "', gender = '" .$gender. "',
                                              addtime = '" .time(). "', logintime = '" .time(). "'";                  
        $conn->execute($sql);
        $uid            = mysql_insert_id();
        $sql            = "INSERT INTO users_prefs (UID) VALUES (" .$uid. ")";
        $conn->execute($sql);
        $sql            = "INSERT INTO users_online (UID, online) VALUES (" .$uid. ", " .time(). ")";
        $conn->execute($sql);
        $code           = VRandom::generate(10, 'confirmation');
        $sql            = "INSERT INTO confirm (UID, code) VALUES (" .$uid. ",'" .mysql_real_escape_string($code). "')";
        $conn->execute($sql);
        $sql            = "SELECT email_subject, email_path FROM emailinfo
                           WHERE email_id = 'verify_email' LIMIT 1";
        $rs             = $conn->execute($sql);
        $email_subject  = str_replace('{$site_name}', $config['site_name'], $rs->fields['email_subject']);
        $email_path     = $config['BASE_DIR'].'/templates/'.$rs->fields['email_path'];
        $smarty->assign('username', $username);
		$smarty->assign('password', $password_clear);
        $smarty->assign('uid', $uid);
        $smarty->assign('code', $code);
        $body           = $smarty->fetch($email_path);
        $mail           = new VMail();
        $mail->setNoReply();
        $mail->Subject  = $email_subject;
        $mail->AltBody  = $body;
        $mail->Body     = nl2br($body);
        $mail->AddAddress($email);
        $mail->Send();
        
        $mail->ClearAddresses();
        $sql            = "SELECT email_subject, email_path FROM emailinfo
                           WHERE email_id = 'welcome' LIMIT 1";
        $rs             = $conn->execute($sql);
        $email_subject  = str_replace('{$site_title}', $config['site_title'], $rs->fields['email_subject']);
        $email_path     = $rs->fields['email_path'];
        $body           = $smarty->fetch($config['BASE_DIR'].'/templates/'.$email_path);
        $mail->Subject  = $email_subject;
        $mail->AltBody  = $body;
        $mail->Body     = nl2br($body);
        $mail->AddAddress($email);
        $mail->Send();
                        
        $_SESSION['message']   = 'You have signed up. Check your email for a verification link!';
        VRedirect::go($config['BASE_URL']);
    }
}

$smarty->assign('errors',$errors);
$smarty->assign('messages',$messages);
$smarty->assign('menu', 'home');
$smarty->assign('signup', $signup);
$smarty->assign('self_title', $seo['signup_title']);
$smarty->assign('self_description', $seo['signup_desc']);
$smarty->assign('self_keywords', $seo['signup_keywords']);
$smarty->display('header.tpl');
$smarty->display('errors.tpl');
$smarty->display('messages.tpl');
$smarty->display('signup.tpl');
$smarty->display('footer.tpl');
$smarty->gzip_encode();
?>
